// minimal example of using the FrSkyV8Tx library
// ceptimus. November 2020

// use different IDs for different transmitters that will be switched on at the same time!
// the ID number should be in the range 0 to 32767
#define TX_ID 12345

// if you know your CC2500's fine tuning value, put it here.
// if you don't know, try 0 first, then try steps of 20 in the range -120 to +120
// ...till you get a bind to your receiver.  There are other examples that show how to
// use a trim pot for tuning.
#define FINE_TUNING 0

#include <FrSkyV8Tx.h> // include the library
FrSkyV8Tx frsky(TX_ID, 10, FINE_TUNING); // create an instance of the class. Chip select on pin 10.
// you don't have to name the instance frsky - you can use any name you like.

void setup() {
  frsky.bind(); // auto-bind mode for ten seconds at startup.
  frsky.start(); // start transmitting (with bind for first ten seconds)
}

void loop() {
}
