;   FrSkyV8Tx library by ceptimus
;   http://http://mode-zero.uk/viewtopic.php?f=42&t=1092
;   derived from Multiprotocol Tx code by Midelic and Pascal Langer(hpnuts)
;   https://github.com/pascallanger/DIY-Multiprotocol-TX-Module/edit/master/README.md
;
; This project is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; FrSkyV8Tx is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with FrSkyV8Tx.  If not, see <http://www.gnu.org/licenses/>.

.global bitBangSPIout

bitBangSPIout: ; (mosiPort, mosiMask, sckPort, sckMask, b)
  mov r23, r22 ; r22 is mosiOrMask
  com r23 ;  make r23 mosiAndmask
  mov r19, r18 ; r18 is sckOrMask
  com r19 ; make r19 sckAndMask
  mov r0, r16 ; byte to transmit in r0
  ldi ZH, 0 ; high byte of Port addresses always zero
  ldi r25, 8 ; loop counter
loop:
  mov ZL, r24
  ld r21, Z ; existing mosiPort contents to r21
  lsl r0 ; transmitting MSB first - this puts the next bit to send into the carry
  brcs bitHigh
  and r21, r23 ; mask the mosi bit low
  rjmp driveMosi
bitHigh:
  or r21, r22 ; mask the mosi bit high
driveMosi:
  st Z, r21 ; write to mosiPort
  mov ZL, r20
  ld r21, Z ; existing sckPort contents to r21
  or r21, r18 ; mask the sck bit high
  st Z, r21 ; write to sckPort - pulse SCK high
  and r21, r19 ; mask sck low again
  st Z, r21 ; write to sckPort - make SCK low again
  dec r25
  brne loop ; loop 8 bits
  mov ZL, r24 ; finish by seting MOSI high
  ld r21, Z
  or r21, r22
  st Z, r21
  ret
