/*  FrSkyV8Tx library by ceptimus
    http://http://mode-zero.uk/viewtopic.php?f=42&t=1092
    derived from Multiprotocol Tx code by Midelic and Pascal Langer(hpnuts)
    https://github.com/pascallanger/DIY-Multiprotocol-TX-Module/edit/master/README.md

 This project is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 FrSkyV8Tx is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with FrSkyV8Tx.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _FRSKYV8TX
#define _FRSKYV8TX

#if defined(__AVR_ATmega328P__) || defined(__AVR_ATmega48__)
#else
  #error This version of the FrSkyV8Tx library has only been tested on the ATmega328P and ATmega48
#endif

#if (F_CPU != 8000000) && (F_CPU != 16000000)
  #error This version of the FrSkyV8Tx library has only been tested at 8 MHz and 16 MHz clock speeds
#endif

#include <Arduino.h>
#include <SPI.h>

class FrSkyV8Tx {
  public:
    FrSkyV8Tx(uint16_t transmitterID, uint8_t CC2500chipSelectPin, int8_t fineTuningValue); // constructor
    FrSkyV8Tx(uint16_t transmitterID, uint8_t cs, uint8_t mosi, uint8_t miso, uint8_t sck, int8_t fineTuningValue); // bit-banged SPI constructor
    void setTransmitterID(uint16_t transmitterID); // for changing it after the constructor (model match)
    void setFineTune(int8_t fineTuningValue); // allow fine tuning value to be altered at any time
    void setTransmitterPower(uint8_t power); // power defaults to 255 normally, automatic 80 while binding
    void start(void); // start transmitting
    void stop(void); // stop transmitting
    void bind(void); // bind mode for 10 seconds. Immediately if transmitting, or after next start
    void setChannel(uint8_t channelNo, int16_t us); // channelNo 0 to 7, pulse width to servo in microseconds
    void setDeglitchedChannel(uint8_t channelNo, int16_t us); // useful for deglitching CPPM-detected values
    uint32_t micros(void); // more accurate version of standard Arduino micros()
    static void staticTimerEvent(void); // kludge to allow ISR call to a class instance method
  private:
    static FrSkyV8Tx* instance; // kludge to allow ISR call to a class instance method
    void instanceTimerEvent(void); // kudge: finally the actual timer event handler!
    bool bitBanged;
    uint8_t packetBuffers[48];
    uint8_t toggle[8]; // used by setDeglitchedChannel()
    int16_t odd[8]; // used by setDeglitchedChannel()
    int16_t even[8]; // used by setDeglitchedChannel()
    uint16_t seed;
    uint8_t phase;
    uint8_t crcID;
    volatile uint8_t* csPort; // pointer for chip select port
    volatile uint8_t* mosiPort; // pointer for MOSI in bit-banged mode
    volatile uint8_t* misoPort; // pointer for MISO in bit-banged mode
    volatile uint8_t* sckPort; // pointer for SCK in bit-banged mode
    uint8_t csMask; // mask for chip select pin
    uint8_t mosiMask; // mask for MOSI in bit-banged mode
    uint8_t misoMask; // mask for MISO in bit-banged mode
    uint8_t sckMask; // mask for SKK in bit-banged mode
    uint8_t txPower;
    uint8_t oldTxPower;
    uint8_t bindCounter; // counts 200 down to 1 while binding.  0 when not binding
    int8_t fineTune;
    int8_t oldFineTune;
    bool transmitting;
    void commonConstructor(uint16_t transmitterID, uint8_t CC2500chipSelectPin, int8_t fineTuningValue);
    void setupOutput(int pin, volatile uint8_t* *port, uint8_t *mask);
    uint8_t crc(uint8_t b, uint8_t *d, uint8_t len); // calculate crc on packet
    void selectCC2500(void); // activate CC2500 chip select pin
    void deselectCC2500(void); // deactivate
    void SPIwrite(uint8_t b);
    void CC2500strobe(uint8_t state);
    void CC2500writeReg(uint8_t address, uint8_t b);
    void CC2500writeRegisterMulti(uint8_t address, uint8_t *b, uint8_t len);
    void CC2500writeData(uint8_t *b, uint8_t len);
    static const PROGMEM uint8_t conf[][2];  // address:data pairs table for configuring CC2500
};
#endif
