#ifndef font_h
#define font_h

// #include <avr/pgmspace.h>

// variable-spaced font, 8 pixels high
// slightly modified from MD_MAX72xx library (c) 2012-14 Marco Colli

const uint8_t font[] PROGMEM = {
  2, 0, 0,     // 32 - 'Space'
  1, 95,    // 33 - '!'
  3, 7, 0, 7,   // 34 - '""'
  5, 20, 127, 20, 127, 20,    // 35 - '#'
  5, 68, 74, 255, 74, 50,   // 36 - '$'
  5, 99, 19, 8, 100, 99,    // 37 - '%'
  5, 54, 73, 73, 54, 72,    // 38 - '&'
  1, 7,   // 39 - '''
  3, 62, 65, 65,    // 40 - '('
  3, 65, 65, 62,    // 41 - ')'
  5, 8, 42, 28, 42, 8,    // 42 - '*'
  5, 8, 8, 62, 8, 8,    // 43 - '+'
  2, 96, 224,   // 44 - ','
  4, 8, 8, 8, 8,    // 45 - '-'
  2, 96, 96,    // 46 - '.'
  5, 96, 16, 8, 4, 3,   // 47 - '/'
  5, 62, 81, 73, 69, 62,    // 48 - '0'
  3, 4, 2, 127, // 49 - '1' see also 127 for digit-width '1'
//  3, 66, 127, 64,   // 49 - serifed '1'
  5, 113, 73, 73, 73, 70,   // 50 - '2'
  5, 65, 73, 73, 73, 54,    // 51 - '3'
  5, 15, 8, 8, 8, 127,    // 52 - '4'
  5, 79, 73, 73, 73, 49,    // 53 - '5'
  5, 62, 73, 73, 73, 48,    // 54 - '6'
  5, 3, 1, 1, 1, 127,   // 55 - '7'
//  5, 1, 1, 121, 5, 3,   // 55 - european style '7'
  5, 54, 73, 73, 73, 54,    // 56 - '8'
  5, 6, 73, 73, 73, 62,   // 57 - '9'
  2, 108, 108,    // 58 - ':'
  2, 108, 236,    // 59 - ';'
  3, 8, 20, 34,   // 60 - '<'
  4, 20, 20, 20, 20,    // 61 - '='
  3, 34, 20, 8,   // 62 - '>'
  5, 1, 89, 9, 9, 6,    // 63 - '?'
  5, 62, 65, 93, 89, 78,    // 64 - '@'
  5, 126, 9, 9, 9, 126,   // 65 - 'A'
  5, 127, 73, 73, 73, 54,   // 66 - 'B'
  5, 62, 65, 65, 65, 65,    // 67 - 'C'
  5, 127, 65, 65, 65, 62,   // 68 - 'D'
  5, 127, 73, 73, 73, 65,   // 69 - 'E'
  5, 127, 9, 9, 9, 1,   // 70 - 'F'
  5, 62, 65, 65, 73, 121,   // 71 - 'G'
  5, 127, 8, 8, 8, 127,   // 72 - 'H'
  3, 65, 127, 65,   // 73 - 'I'
  5, 48, 65, 65, 65, 63,    // 74 - 'J'
  5, 127, 8, 20, 34, 65,    // 75 - 'K'
  5, 127, 64, 64, 64, 64,   // 76 - 'L'
  5, 127, 2, 12, 2, 127,    // 77 - 'M'
  5, 127, 4, 8, 16, 127,    // 78 - 'N'
  5, 62, 65, 65, 65, 62,    // 79 - 'O'
  5, 127, 9, 9, 9, 6,   // 80 - 'P'
  5, 62, 65, 65, 97, 126,   // 81 - 'Q'
  5, 127, 9, 25, 41, 70,    // 82 - 'R'
  5, 70, 73, 73, 73, 49,    // 83 - 'S'
  5, 1, 1, 127, 1, 1,   // 84 - 'T'
  5, 63, 64, 64, 64, 63,    // 85 - 'U'
  5, 31, 32, 64, 32, 31,    // 86 - 'V'
  5, 63, 64, 56, 64, 63,    // 87 - 'W'
  5, 99, 20, 8, 20, 99,   // 88 - 'X'
  5, 3, 4, 120, 4, 3,   // 89 - 'Y'
  5, 97, 81, 73, 69, 67,    // 90 - 'Z'
  3, 127, 65, 65,   // 91 - '['
  5, 3, 4, 8, 16, 96,   // 92 - '\'
  3, 65, 65, 127,   // 93 - ']'
  5, 4, 2, 1, 2, 4,   // 94 - '^'
  4, 128, 128, 128, 128,    // 95 - '_'
  3, 1, 2, 4,   // 96 - '`'
  4, 56, 68, 68, 124,   // 97 - 'a'
  4, 127, 68, 68, 56,   // 98 - 'b'
  4, 56, 68, 68, 68,    // 99 - 'c'
  4, 56, 68, 68, 127,   // 100 - 'd'
  4, 56, 84, 84, 88,    // 101 - 'e'
  4, 4, 126, 5, 1,    // 102 - 'f'
  4, 24, 164, 164, 124,   // 103 - 'g'
  4, 127, 4, 4, 120,    // 104 - 'h'
  1, 122,   // 105 - 'i'
  3, 132, 133, 124,   // 106 - 'j'
  4, 127, 16, 40, 68,   // 107 - 'k'
  1, 127,   // 108 - 'l'
  5, 124, 4, 120, 4, 120,   // 109 - 'm'
  4, 124, 4, 4, 120,    // 110 - 'n'
  4, 56, 68, 68, 56,    // 111 - 'o'
  4, 252, 36, 36, 24,   // 112 - 'p'
  4, 24, 36, 36, 252,   // 113 - 'q'
  4, 124, 4, 4, 8,    // 114 - 'r'
  4, 88, 84, 84, 52,    // 115 - 's'
  3, 4, 127, 4,   // 116 - 't'
  4, 60, 64, 64, 124,   // 117 - 'u'
  4, 28, 32, 64, 124,   // 118 - 'v'
  5, 60, 64, 48, 64, 60,    // 119 - 'w'
  4, 108, 16, 16, 108,    // 120 - 'x'
  4, 28, 160, 160, 124,   // 121 - 'y'
  4, 100, 84, 84, 76,   // 122 - 'z'
  4, 8, 54, 65, 65,   // 123 - '{'
  1, 127,   // 124 - '|'
  4, 65, 65, 54, 8,   // 125 - '}'
  4, 2, 1, 2, 1,    // 126 - '~'
  5, 0, 4, 2, 127, 0,   // 127 - '1' (same as 49, but wider) print with \177 (octal)
};

#endif
