// config file for DotMatrixMemoClockWeather8266 sketch
// edit the lines below to specify your WiFi SSID, password, your OpenWeatherMap ID, location, units to use, etc.

#ifndef _CONFIG_H
#define _CONFIG_H

#define WIFI_SSID "Your WiFi SSID"
#define WIFI_PASSWORD "Your WiFi password"

#define OPEN_WEATHER_MAP_ID "Your openweathermap.org id"
#define LOCATION "Studley,GB"
// define only one of the TEMPERATURE_ constants below - comment out the other one with //
#define TEMPERATURE_CELSIUS
// #define TEMPERATURE_FAHRENHEIT

// define only one of the WIND_SPEED_ constants below - comment out the other one with //
// #define WIND_SPEED_METRES_PER_SECOND
#define WIND_SPEED_MILES_PER_HOUR

// comment out with // if you don't want wind gust speed displayed
// #define DISPLAY_WIND_GUST_SPEED

// how often to check OpenWeatherMap for a weather update in milliseconds - 60000 equals once per minute
#define WEATHER_UPDATE_INTERVAL 300000

// change following lines to suit your country and time zone.
// See https://remotemonitoringsystems.ca/time-zone-abbreviations.php
// See https://www.ntppool.org/en/
#define NTP_TIME_SERVERS "pool.ntp.org", "time.nist.gov"
#define TIME_ZONE_SETTINGS "   GMT+0BST-1,M3.5.0/01:00:00,M10.5.0/02:00:00", 1

// sketch defaults to 24-hour-clock mode. uncomment following #define to instead use 12-hour mode: removes leading zero from hours and uses AM / PM instead of seconds
// #define TWELVE_HOUR_CLOCK

// this is the pin to provide power (VCC) to the temperature sensor.  Pin 16 is labelled D2 on the Wemos D1 R1, and labelled D0 on the Wemos D1 R2
#define DS18B20_POWER_PIN 16

// this is the pin to provide GND to the temperature sensor.  Pin 4 is labelled D4 on the Wemos D1 R1, and labelled D2 on the Wemos D1 R2
#define DS18B20_GND_PIN 4

// this is the one-wire (signal) pin for the temperature sensor.  Pin 5 is labelled D3 on the Wemos D1 R1, and labelled D1 on the Wemos D1 R2
#define DS18B20_ONE_WIRE_PIN 5

// there are lots of fake DS18B20s around.  They work okay but have big temperature offsets.
// set the following to a non-zero value to apply a temperature offset to the value read from the sensor, till it agrees with a known 'good' thermometer.  Units are 1/16 degree C
// use a negative correction if your sensor reads high, and a positive one if it reads low
#define DS18B20_TEMPERATURE_CORRECTION 0

// how often to read the DS18B20 temperature sensor in milliseconds - 5000 equals once every five seconds
#define TEMPERATURE_UPDATE_INTERVAL 5000

#endif
