#ifndef ceptimusMAX72___h
#define ceptimusMAX72___h

#include <Arduino.h>
#include <SPI.h>

// Driver for arbritary-sized rectangular array of N 8x8 LED dot-matrix modules 
// using SPI Max7219 or compatible chips.
// addressMap() maps dot-matrix chip address (0-(N-1)) to a bitmap byte address - the function
// depends on how you wired up the modules. The function must return the bitmap address for the left 
// column of pixels in each 8x8 block. You can always use a look-up table (size N) if the function
// is too complex. Bitmap consists of N*8 bytes arranged with the bytes running VERTICALLY,
// the origin is at the bottom left with the most significant bit of the first byte at the origin.
// addressing (x, y) for text/graphics functions: x runs left to right, y top to bottom. 

#define MAX_ZONES 8

class ceptimusMAX72__ {
  public:
    ceptimusMAX72__(int CS_pin, int numChips, int chipsInRow, int (*addressMap)(int)); // constructor
    void wake(int state);
    void refresh(); // refresh display - call regularly - handles scrolling
    void clr(); // clear whole display bitmap
    void setBrightness(int b); // 0 to 15
    void setPixel(int x, int y, bool state);
    bool getPixel(int x, int y);
    // hollow box. Can also draw horizontal and vertical lines
    void box(int x1, int y1, int x2, int y2, bool state);
    // specify a print 'window'. Text will be centred in window if it fits, or scrolled otherwise.
    void createZone(int id, int x1, int y, int x2, int msScroll = 50, int msScrollStart = 800);
    void text(int zone, const char *s, bool rvs = false);
    int widthText(const char *s); // returns width of text, in pixels, including the final terminating 'space' pixel.
    int awake;
  private:
    int N; // number of chips
    int CS; // pin for driving LOAD (CS-barred) pin on Max chips
    int hght; // height of display in chips (1 chip = 8 pixel width)
    int pWidth, pHeight; // width and height of display in pixels
    bool zoneActive[MAX_ZONES];
    int zoneX[MAX_ZONES];
    int zoneY[MAX_ZONES];
    int zoneWidth[MAX_ZONES];
    int zoneMS[MAX_ZONES];
    int zoneMSstart[MAX_ZONES];
    String zoneString[MAX_ZONES];
    bool zoneRvs[MAX_ZONES];
    int zoneTextStart[MAX_ZONES];
    uint32_t zoneNextMS[MAX_ZONES];
    uint8_t* bitmap;
    int (*addr)(int); // addressMap function pointer
    void cmd(uint8_t adr, uint8_t b); // write byte to address in all N chips
    void clip(int *n, int mn, int mx); // clip integer to limits if outside range
    // clip the first [start] pixels of the text, plus any text after x2
    void text(int x1, int y, int x2, int start, const char *s, bool rvs);
};
#endif
